﻿ALTER PROCEDURE [dbo].[P_TBL_RESOURCE_GRP_ADDMOD]
@gid INT, @rgid INT, @gid_tid INT, @tid INT, @type INT, @group_name NVARCHAR (200), @group_desc NVARCHAR (128), @mask VARCHAR (20), @lm_oper_gid INT, @lm_oper_id INT, @del_stat VARCHAR (1)
AS
begin
  -- Resource csoportot vesz fel vagy módosít meg.

  declare @result       integer
  declare @err          integer

  SET NOCOUNT ON
  SET XACT_ABORT OFF

  set @result = 0
  
  if ((@gid IS null) or (@gid <= 0)) set @gid = dbo.F_SYS_GID()
  if (@rgid IS null) set @rgid = -1
  if ((@lm_oper_id IS null) or (@lm_oper_id < 0)) set @lm_oper_id = dbo.F_SYS_GET_ACT_OPER_ID()

  if (@rgid <= 0)
     begin
     INSERT INTO dbo.[RESOURCE_GRP] VALUES (@gid,@gid_tid,@tid,@type,@group_name,@group_desc ,@mask, @lm_oper_gid, @lm_oper_id, getdate(), @del_stat, 0 ,0)
     set @result = @@IDENTITY
     end
  else
     begin
     UPDATE dbo.[RESOURCE_GRP]
        set dbo.[RESOURCE_GRP].GID_TID = @gid_tid,
            dbo.[RESOURCE_GRP].TID = @tid,
            dbo.[RESOURCE_GRP].[TYPE] = @type,
            dbo.[RESOURCE_GRP].GROUP_NAME = @group_name,
            dbo.[RESOURCE_GRP].GROUP_DESC = @group_desc,
            dbo.[RESOURCE_GRP].MASK = @mask,
            dbo.[RESOURCE_GRP].LM_OPER_GID = @lm_oper_gid,
            dbo.[RESOURCE_GRP].LM_OPER_ID = @lm_oper_id,
            dbo.[RESOURCE_GRP].LM_DATE = GETDATE(),
            dbo.[RESOURCE_GRP].DEL_STAT = @del_stat,
            dbo.[RESOURCE_GRP].SYNC_STAT = 0,
            dbo.[RESOURCE_GRP].CHK = 0
      WHERE dbo.[RESOURCE_GRP].GID = @gid
        AND dbo.[RESOURCE_GRP].RGID = @rgid

     end

  SET NOCOUNT OFF
  return (@result)
end